/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.autoupdate;

import com.quantumdata.autoupdate.AutoUpdateGUI;
import com.quantumdata.autoupdate.Device88X;
import com.quantumdata.autoupdate.UpgradeScreen;
import com.quantumdata.autoupdate.WebInterface;
import com.quantumdata.autoupdate.WebInterfaceException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class CheckForUpgradeScreen
extends UpgradeScreen {
    private final String btnCancelCmd = "CANCEL";
    private final String doneCmd = "DONE";
    private final String btnBackCmd = "BACK";
    private final String evtLocalZipFile = "LOCAL_ZIP";
    private JProgressBar m_progressBar;
    private JLabel m_txtInstruction;
    private Device88X m_Dev88X;
    private Action m_act;
    private Thread m_netThread;
    private WebInterface m_theWeb;

    public CheckForUpgradeScreen(String string, AutoUpdateGUI autoUpdateGUI) {
        super(string, autoUpdateGUI);
        this.configureJFrame(autoUpdateGUI);
    }

    protected void finalize() {
        System.out.println("Destroying Web Data Address Window");
        super.finalize();
        this.m_progressBar = null;
        this.m_theWeb = null;
        this.m_txtInstruction = null;
    }

    private void configureJFrame(ActionListener actionListener) {
        Container container = super.getJFrame().getContentPane();
        this.m_txtInstruction = new JLabel("Downloading Upgrade File from the Quantum Data Website.");
        this.m_act = new UpgradeScreen.AutomaticActionEvent(this, actionListener);
        this.m_progressBar = new JProgressBar(0, 100);
        this.m_progressBar.setIndeterminate(true);
        this.m_progressBar.setValue(0);
        this.m_progressBar.setPreferredSize(new Dimension(500, 20));
        JButton jButton = new JButton("Cancel");
        jButton.setVerticalTextPosition(0);
        jButton.setHorizontalTextPosition(10);
        jButton.setMnemonic('C');
        jButton.setActionCommand("CANCEL");
        jButton.addActionListener(actionListener);
        JButton jButton2 = new JButton("Next (Test Purposes Only)");
        jButton2.setVerticalTextPosition(0);
        jButton2.setHorizontalTextPosition(10);
        jButton2.setMnemonic('N');
        jButton2.setActionCommand("DONE");
        jButton2.addActionListener(actionListener);
        jButton2.setVisible(false);
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        int n = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 0, n, 0);
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.m_txtInstruction, gridBagConstraints);
        jPanel.add(this.m_txtInstruction);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, n, 0);
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.m_progressBar, gridBagConstraints);
        jPanel.add(this.m_progressBar);
        JPanel jPanel2 = new JPanel();
        super.setLogo(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        container.add((Component)jPanel2, "First");
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel3, "Last");
        container.validate();
    }

    public int ScreenHandler(ActionEvent actionEvent, int n, Device88X device88X) {
        int n2 = n;
        if ("CANCEL".equals(actionEvent.getActionCommand())) {
            System.out.println("Exiting");
            System.exit(0);
        } else if ("DONE".equals(actionEvent.getActionCommand())) {
            n2 = 6;
            device88X.setLocalZipFileFlag(false);
            System.out.println("Going to download Screen: ID=" + n2);
        } else if (actionEvent.getActionCommand().equalsIgnoreCase("BACK")) {
            n2 = -1;
            System.out.println("Going to Previous Screen: ID=" + n2);
        } else if (actionEvent.getActionCommand().equalsIgnoreCase("LOCAL_ZIP")) {
            n2 = 18;
            device88X.setLocalZipFileFlag(true);
            System.out.println("Going to Local Zip Screen: ID=" + n2);
        }
        return n2;
    }

    public void run(Device88X device88X) {
        this.m_Dev88X = device88X;
        this.m_netThread = new Thread(new runGetWebFileThread(super.getJFrame()));
        this.m_netThread.setName("Check Versions Web Thread");
        this.m_netThread.start();
    }

    public void refresh() {
        super.refresh();
    }

    class runGetWebFileThread
    implements Runnable {
        private JFrame m_runFrame;

        public runGetWebFileThread(JFrame jFrame) {
            this.m_runFrame = jFrame;
        }

        public synchronized void run() {
            ActionEvent actionEvent;
            block25: {
                actionEvent = new ActionEvent(this, 1001, "DONE");
                CheckForUpgradeScreen.this.m_act.setEnabled(true);
                try {
                    CheckForUpgradeScreen.this.m_theWeb = new WebInterface(CheckForUpgradeScreen.this.m_Dev88X, "http://www.quantumdata.com/downloads/release.php", 0);
                }
                catch (MalformedURLException malformedURLException) {
                    JOptionPane.showMessageDialog(this.m_runFrame, "Bad URL: " + CheckForUpgradeScreen.this.m_theWeb.getURL(), "Bad URL", 0);
                }
                try {
                    CheckForUpgradeScreen.this.m_theWeb.checkForUpgrade(this.m_runFrame, CheckForUpgradeScreen.this.m_progressBar, CheckForUpgradeScreen.this.m_txtInstruction);
                    CheckForUpgradeScreen.this.m_Dev88X.setUpgradeURL(CheckForUpgradeScreen.this.m_theWeb.getUpgradeFile());
                    CheckForUpgradeScreen.this.m_Dev88X.setDownloadSWVersion(CheckForUpgradeScreen.this.m_theWeb.getUpgradeVersion());
                    System.out.println("Upgrade Link: " + CheckForUpgradeScreen.this.m_Dev88X.getUpgradeURL());
                }
                catch (WebInterfaceException webInterfaceException) {
                    String string = "Error";
                    String string2 = "Error";
                    boolean bl = true;
                    int n = 0;
                    int n2 = -1;
                    if (webInterfaceException.getUpgradeStatus() != null) {
                        if (webInterfaceException.getUpgradeStatus().equalsIgnoreCase("SAME_VERSION")) {
                            string2 = "No Upgrade Needed";
                            string = "Your 88X Generator currently has the latest version.\nClick OK to exit.";
                            n = -1;
                            n2 = JOptionPane.showConfirmDialog(this.m_runFrame, "Your Generator currently has the latest version\nWould you like to continue with the upgrade anyway?", "Same Version", 0);
                            System.out.println("^^^^ Option Value = " + n2);
                            if (n2 == 0) {
                                CheckForUpgradeScreen.this.m_Dev88X.setUpgradeURL(CheckForUpgradeScreen.this.m_theWeb.getUpgradeFile());
                                CheckForUpgradeScreen.this.m_Dev88X.setDownloadSWVersion(CheckForUpgradeScreen.this.m_theWeb.getUpgradeVersion());
                                System.out.println("Upgrade Link: " + CheckForUpgradeScreen.this.m_Dev88X.getUpgradeURL());
                                bl = false;
                            } else {
                                bl = true;
                            }
                        } else if (webInterfaceException.getUpgradeStatus().equalsIgnoreCase("NO_UPGRADE_AVAILABLE")) {
                            string2 = "No Upgrade Available";
                            string = "No Upgrade is Available at this time.\nPlease check again later.";
                            n = -1;
                            if (!CheckForUpgradeScreen.this.m_Dev88X.isUsePCMCIA()) {
                                JOptionPane.showMessageDialog(this.m_runFrame, string, string2, n);
                            } else {
                                Object[] objectArray = new Object[]{"Back", "Cancel Upgrage"};
                                n2 = JOptionPane.showOptionDialog(this.m_runFrame, string = string + "\nOR\nSelect the \"Back\" Button to modify Genstats Information.", string2, 1, n, null, objectArray, objectArray[0]);
                                if (n2 == 0) {
                                    actionEvent = new ActionEvent(this, 1001, "BACK");
                                    bl = false;
                                } else {
                                    bl = true;
                                }
                            }
                        } else if (webInterfaceException.getUpgradeStatus().equalsIgnoreCase("HOST_NOT_ACCESSIBLE")) {
                            string2 = "Host Not Reachable";
                            string = "Please check firewall/proxy settings.\n If you already have the upgrade file locally, please select continue.";
                            n = 1;
                            Object[] objectArray = new Object[]{"Continue", "Cancel Upgrage"};
                            n2 = JOptionPane.showOptionDialog(this.m_runFrame, string, string2, 1, n, null, objectArray, objectArray[0]);
                            if (n2 == 0) {
                                actionEvent = new ActionEvent(this, 1001, "LOCAL_ZIP");
                                bl = false;
                            } else {
                                bl = true;
                            }
                        } else {
                            string2 = "Error";
                            string = webInterfaceException.getWebErrorMessage();
                            n = 0;
                            JOptionPane.showMessageDialog(this.m_runFrame, string, string2, n);
                        }
                    } else if (webInterfaceException.getWebResponseCode() > 0) {
                        string2 = "Web Error";
                        string = "Web Host returned an code of " + webInterfaceException.getWebResponseCode() + "\n" + webInterfaceException.getWebResponseMessage();
                        n = 1;
                        JOptionPane.showMessageDialog(this.m_runFrame, string, string2, n);
                    } else if (webInterfaceException.getUpgradeStatus() == null) {
                        string2 = "Web Error";
                        string = "Error: " + webInterfaceException.getWebResponseMessage();
                        n = 0;
                        JOptionPane.showMessageDialog(this.m_runFrame, string, string2, n);
                    }
                    if (!bl) break block25;
                    System.out.println("Exiting");
                    System.exit(0);
                }
            }
            CheckForUpgradeScreen.this.refresh();
            try {
                Thread.yield();
                Thread.sleep(1000L);
                Thread.yield();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            CheckForUpgradeScreen.this.m_act.actionPerformed(actionEvent);
            System.out.println("Check For Upgrade Screen... Exiting run Thread");
        }
    }
}

